%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This work by EPFL STI IBI LBNI is licensed under 
% a Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
% Based on a work at http://lbni.epfl.ch/.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if strcmp(Offset_data,'Y')
      
            intermediate_image                          = images(:,:, j);
            [height_offset_calc position_offset_calc]   = hist(reshape(intermediate_image(:,:),size(images,1)*size(images,2),1),256);                                                                 % Calculates the histogram of the corrected height data (First image only)
            [peak_height_hist peak_index_hist]          = findpeaks(smooth(height_offset_calc,5,'loess'),'MinpeakDistance', 8, 'Sortstr','descend');                                         % Finds peaks in the corrected image to identify different terrace
            
            peak_index_hist = sort(peak_index_hist(1:min(3, length(peaks_fit(j)))),'ascend');
            peak_height_hist = height_offset_calc(peak_index_hist);
            
            func_form                                   = [];
            t_hist_lower_a                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                              % Initializes the lower bounds for fitting
            t_hist_lower_s                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                              % Initializes the lower bounds for fitting
            t_hist_lower_x                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                              % Initializes the lower bounds for fitting
            t_hist_upper_a                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                              % Initializes the upper bounds for fitting
            t_hist_upper_s                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                              % Initializes the upper bounds for fitting
            t_hist_upper_x                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                              % Initializes the upper bounds for fitting
            t_hist_start_a                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                                        % Initializes the start point for fitting
            t_hist_start_s                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                                        % Initializes the start point for fitting
            t_hist_start_x                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                                        % Initializes the start point for fitting

            for i                                       = 1:min(peaks_fit(j),length(peak_height_hist))                                                                                                % Loops for the minimum of the number of peaks or 3
                t_hist_lower_a(i)                       = (1-amplitude_fract)*peak_height_hist(i);                                                                                                 % Sets the lower amplitude bound for the fit
                t_hist_lower_s(i)                       = min_spacing_stdev(j);                                                                                                                     % Sets the lower standard deviation
                t_hist_lower_x(i)                       = position_offset_calc(max([1,peak_index_hist(i)-4]));                                                                                                   % Sets the lower center relative to the peak

                t_hist_upper_a(i)                       = (1+amplitude_fract)*peak_height_hist(i);                                                                                                 % Sets the upper amplitude bound for the fit
                t_hist_upper_s(i)                       = max_spacing_stdev(j);                                                                                                                     % Sets the upper standard deviation
                t_hist_upper_x(i)                       = position_offset_calc(min([peak_index_hist(i)+4,length(position_offset_calc)]));                                                                                                   % Sets the upper center relative to the peak

                t_hist_start_a(i)                       = 1.00*peak_height_hist(i);                                                                                                                % Sets the starting amplitude bound for the fit
                t_hist_start_s(i)                       = (min_spacing_stdev(j)+max_spacing_stdev(j))/2;                                                                                            % Sets the starting standard deviation
                t_hist_start_x(i)                       = position_offset_calc(peak_index_hist(i));                                                                                                              % Sets the starting center relative at the peak
                func_form                               = [func_form,'a',num2str(i),'*exp(-(x-x',num2str(i),')^2/(2*(s',num2str(i),')^2))'];                                                        % Generates the functional form to fit                                                  
                if i                                    < min(peaks_fit(j),length(peak_height_hist))
                    func_form                           = [func_form,'+'];                                                                                                                          % Generates the functional form to fit
                end
            end

            % Combines all the bouds into a form for the fits
            t_hist_lower                                = [t_hist_lower_a,t_hist_lower_s,t_hist_lower_x];                                                                                           % Combines the lower bounds
            t_hist_upper                                = [t_hist_upper_a,t_hist_upper_s,t_hist_upper_x];                                                                                           % Combines the upper bounds
            t_hist_start                                = [t_hist_start_a,t_hist_start_s,t_hist_start_x];                                                                                           % Combines the start point

            % Fits the data with the speficied conditions
            t_hist                                      = fitoptions(   'Method','NonlinearLeastSquares',...                                                                                        % Sets the conditions for fitting
                                                                        'Lower',      t_hist_lower,...
                                                                        'Upper',      t_hist_upper,...
                                                                        'Startpoint', t_hist_start,...
                                                                        'MaxIter',    1e2,...
                                                                        'MaxFunEvals',3e2);
            f_Number_hist                               = fittype(func_form,  'options' ,t_hist);
            [peak_hist_gaussian,peak_hist_gaussian_gof] = fit( position_offset_calc',...
                                                                 smooth(height_offset_calc,5,'loess'),...
                                                                 f_Number_hist);
         if length(peak_height_hist) >= peak_reference_height(j)
                eval(['peak_hist_gaussian_x_ref = peak_hist_gaussian.x', num2str(peak_reference_height(j)), ';']);
         else
                peak_hist_gaussian_x_ref = peak_hist_gaussian.x1;
         end
         
         intermediate_image(:,:)                                     = intermediate_image(:,:) + z_height_reference(j) - peak_hist_gaussian_x_ref;                           % Sets first peak to reference height                                                                                         % Adds the user selected Z-offset
        
        else
        end
            
        %% Computes a final histogram and CDF of the corrected image and fits Gaussians (like before)  Displays the final histogram and fits and saves plots 

        if index == 1 && j == channels_flatten(1)
            figure_hand_interm_hist                            = figure('Name','Intermediate hist');
        else
            figure(figure_hand_interm_hist);    
        end
        
        [tok remain]                                    = strtok(Filename{index},'.');
        file_number                                     = str2double(remain(2:4));
        if index == 1 && ~strcmp(overwrite_xlim,'Yes')
            [h_lim x_lim]                               = ecdf(reshape(intermediate_image(:,:),size(images,1)*size(images,2),1));
            min_z(j)                                    = floor(x_lim(find(h_lim >= 0.01,1)));
            max_z(j)                                    =  ceil(x_lim(find(h_lim >= 0.99,1)));
            span_z                                      = max_z(j) - min_z(j);
            min_z(j)                                    =  ceil(min_z(j)-0.05*span_z);
            max_z(j)                                    = floor(max_z(j)+0.05*span_z);
            
        else
        end
        [y1_data x_data]                                = hist(reshape(intermediate_image(:,:),size(images,1)*size(images,2),1),min_z(j):(max_z(j)-min_z(j))/255:max_z(j));
        y2_data                                         = zeros(size(y1_data,1),1);

        x_data                                          = x_data';
        y1_data                                         = y1_data';
        y1_data                                         = 100*y1_data/sum(y1_data);
        for i                                           = 1:size(y1_data,1)
            y2_data(i,1)                                = sum(y1_data(1:i));
        end
        
        [AX,H1,H2]                                      = plotyy(x_data,y1_data,x_data,y2_data,'plot');
        set(AX(1),'YColor','k');
        set(AX(2),'YColor','r');
        axis auto;
        
        set(AX(1),'YLim',[-0.002*ceil(max(y1_data)) 1.002*ceil(max(y1_data))],'YTick',0:ceil(max(y1_data))/10:ceil(max(y1_data)),'YTickLabel',0:ceil(max(y1_data))/10:ceil(max(y1_data)))
        set(AX(2),'YLim',[-0.2 100.2],'YTick',0:10:100,'YTickLabel',0:10:100) 
            axis_lim = [min_z(j),max_z(j)];
            set(AX(1),'XLim',axis_lim(1:2),'XTick',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2),'XTickLabel',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2));
            set(AX(2),'XLim',axis_lim(1:2),'XTick',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2),'XTickLabel',axis_lim(1):(axis_lim(2)-axis_lim(1))/10:axis_lim(2));

        set(AX(1),'yticklabel',sprintf('%0.1f |',get(AX(1),'ytick')'));
        set(AX(2),'yticklabel',sprintf('%0.0f |',get(AX(2),'ytick')'));
        set(get(AX(1),'Ylabel'),'String','% Area','FontSize', FontSize, 'FontName', FontName,'Color','k');
        set(get(AX(2),'Ylabel'),'String','% Below Given Value','FontSize', FontSize, 'FontName', FontName,'Color','r');

        set(H1,'Color','k','LineWidth',2);
        set(H2,'Color','r','LineWidth',2);

        xlabel([channel_info(j).Name,' (',channel_info(j).Unit,')'],'FontSize', FontSize, 'FontName', FontName );
        title([channel_info(j).Name,'(',num2str(j),')',' ',num2str(file_number)],'FontSize', FontSize*1.5, 'FontName', FontName ); 
        set(AX(1),'FontSize', FontSize, 'FontName', FontName);
        set(AX(2),'FontSize', FontSize, 'FontName', FontName);

        if strcmp(disp_percent, 'Yes')
        percent_val                                     = zeros(length(percent_search),1);
        text_disp                                       =  cell(length(percent_search),1);
        for i                                           = 1:length(percent_search)
            index_height                                = find(y2_data >= percent_search(i),1);
            percent_val(i)                              = x_data(index_height);
            text_disp{i,1}                              = [num2str(percent_search(i)),'% below ',num2str(percent_val(i),'%02.2f'),' ',channel_info(j).Unit];
        end
        else
        end

        x_range                                         = get(AX(1),'XLim'); 
        y_range                                         = get(AX(1),'YLim');
        text(x_range(2) -.02*(x_range(2)-x_range(1)),y_range(2)-.02*(y_range(2)-y_range(1)),text_disp,'FontSize', 0.75*FontSize, 'FontName', FontName,'VerticalAlignment','top','HorizontalAlignment','right' );

        if strcmp(fit_hist,'Yes')            
            [peak_height_hist peak_index_hist]          = findpeaks(smooth(y1_data,8,'loess'),'MinpeakDistance', 8,'Sortstr','descend');                                                                       % Finds peaks in the corrected image to identify different terrace
            func_form                                   = [];
            t_hist_lower_a                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                                        % Initializes the lower bounds for fitting
            t_hist_lower_s                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                                        % Initializes the lower bounds for fitting
            t_hist_lower_x                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                                        % Initializes the lower bounds for fitting
            t_hist_upper_a                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                                        % Initializes the upper bounds for fitting
            t_hist_upper_s                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                                        % Initializes the upper bounds for fitting
            t_hist_upper_x                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                                        % Initializes the upper bounds for fitting
            t_hist_start_a                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                                        % Initializes the start point for fitting
            t_hist_start_s                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                                        % Initializes the start point for fitting
            t_hist_start_x                              = zeros(1,min(peaks_fit(j),length(peak_height_hist)));                                                                                        % Initializes the start point for fitting

            for i                                       = 1:min(peaks_fit(j),length(peak_height_hist))                                                                                                % Loops for the minimum of the number of peaks or 3
                t_hist_lower_a(i)                       = (1-amplitude_fract)*peak_height_hist(i);                                                                                                 % Sets the lower amplitude bound for the fit
                t_hist_lower_s(i)                       = min_spacing_stdev(j);                                                                                                                     % Sets the lower standard deviation
                t_hist_lower_x(i)                       = x_data(max([1,peak_index_hist(i)-3]));                                                                                                   % Sets the lower center relative to the peak

                t_hist_upper_a(i)                       = (1+amplitude_fract)*peak_height_hist(i);                                                                                                 % Sets the upper amplitude bound for the fit
                t_hist_upper_s(i)                       = max_spacing_stdev(j);                                                                                                                     % Sets the upper standard deviation
                t_hist_upper_x(i)                       = x_data(min([peak_index_hist(i)+3,length(x_data)]));                                                                                                   % Sets the upper center relative to the peak

                t_hist_start_a(i)                       = 1.00*peak_height_hist(i);                                                                                                                % Sets the starting amplitude bound for the fit
                t_hist_start_s(i)                       = (min_spacing_stdev(j)+max_spacing_stdev(j))/2;                                                                                            % Sets the starting standard deviation
                t_hist_start_x(i)                       = x_data(peak_index_hist(i));                                                                                                              % Sets the starting center relative at the peak
                func_form                               = [func_form,'a',num2str(i),'*exp(-(x-x',num2str(i),')^2/(2*(s',num2str(i),')^2))'];                                                        % Generates the functional form to fit                                                  
                if i                                    < min(peaks_fit(j),length(peak_height_hist))
                    func_form                           = [func_form,'+'];                                                                                                                          % Generates the functional form to fit
                end
            end

            % Combines all the bouds into a form for the fits
            t_hist_lower                                = [t_hist_lower_a,t_hist_lower_s,t_hist_lower_x];                                                                                           % Combines the lower bounds
            t_hist_upper                                = [t_hist_upper_a,t_hist_upper_s,t_hist_upper_x];                                                                                           % Combines the upper bounds
            t_hist_start                                = [t_hist_start_a,t_hist_start_s,t_hist_start_x];                                                                                           % Combines the start point

            % Fits the data with the speficied conditions
            t_hist                                      = fitoptions(   'Method','NonlinearLeastSquares',...                                                                                        % Sets the conditions for fitting
                                                                        'Lower',      t_hist_lower,...
                                                                        'Upper',      t_hist_upper,...
                                                                        'Startpoint', t_hist_start,...
                                                                        'MaxIter',    1e2,...
                                                                        'MaxFunEvals',3e2);
            f_Number_hist                               = fittype(func_form,  'options' ,t_hist);
            [peak_hist_gaussian,peak_hist_gaussian_gof] = fit( x_data,...
                                                                 smooth(y1_data,5,'loess'),...
                                                                 f_Number_hist);

        hold on
        plot(x_data,peak_hist_gaussian(x_data),'.b','LineWidth',2);
        for i                                           = 1:min(peaks_fit(j),length(peak_height_hist))
        text(1.05*eval(['peak_hist_gaussian.x',num2str(i)]),...
         0.85*eval(['peak_hist_gaussian.a',num2str(i)]),...
         { [num2str(sum(eval(['peak_hist_gaussian.a',num2str(i),'*exp(-(x_data-peak_hist_gaussian.x',num2str(i),').^2/(2*(peak_hist_gaussian.s',num2str(i),')^2))'])),'%02.2f'),'% @'];...
           [num2str(eval(['peak_hist_gaussian.x',num2str(i)]),'%02.2f'),' +- ',num2str(eval(['peak_hist_gaussian.s',num2str(i)]),'%02.2f'),' ',channel_info(j).Unit]},...
         'FontSize', 0.75*FontSize, 'FontName', FontName,'VerticalAlignment','bottom','HorizontalAlignment','left','color','b' );
        end

        else
        end

        print('-loose',  '-djpeg' ,  [ImageDir,'Matlab/Figure Jpegs/',channel_info(j).Name,'/hist/',channel_info(j).Name,'(',num2str(j),')','_',num2str(file_number),'intermediate_hist_cdf.jpg']);
        saveas(gcf,                                             [ImageDir,'Matlab/Figure Figs/',channel_info(j).Name,'(',num2str(j),')','_',num2str(file_number),'intermediate_hist_cdf.fig']);
        hold off;
        %close gcf;

        %% Plots the final corrected image with user set color and scale bars and saves the output    
        ScanZ                                       = max_z(j)-min_z(j);                                                                                                                    % Sets the user defined data scale for each channel
        if index == 1 && j ==  channels_flatten(1)
        figure_hand_interm_image = figure('Name','Intermediate image');
        else
        figure(figure_hand_interm_image);    
        end
        
        imshow(imresize(intermediate_image(:,:),[max(size(intermediate_image(:,:))),max(size(intermediate_image(:,:)))]),[min_z(j),max_z(j)])                                      % Generates a new Figure with the name of the correct channel,  Resizes the image to a square the size of the largest dimension.  This is useful when using nonsquare pixels.  Sets the display range from the min to the max
        print('-djpeg' , [ImageDir,'Matlab/Figure Jpegs/',channel_info(j).Name,'/grey/',channel_info(j).Name,'(',num2str(j),')','_',num2str(file_number),'_grey.jpg']);                                   % Saves the images.  I'm not sure if i dig the naming just yet.  I'll deal with it later
                                                                                                                                                                                    % Loads the Georg approved colormap
        colormap(mycmap_sky);                                                                                                                                                               % Sets the colormap 
            hcb= colorbar('YTick',min_z(j):ScanZ/10:max_z(j),...
                          'YTickLabel',{            [num2str(min_z(j)+0*ScanZ/10,'%0.2f'),' ', channel_info(j).Unit],...                                                                    % Inserts a color bar.  Sets the 1st tick with approriate labels
                                                    [num2str(min_z(j)+1*ScanZ/10,'%0.2f'),' ', channel_info(j).Unit],...                                                                    % Sets the 2nd tick with approriate labels
                                                    [num2str(min_z(j)+2*ScanZ/10,'%0.2f'),' ', channel_info(j).Unit],...                                                                    % Sets the 3rd tick with approriate labels
                                                    [num2str(min_z(j)+3*ScanZ/10,'%0.2f'),' ', channel_info(j).Unit],...                                                                    % Sets the 4th tick with approriate labels
                                                    [num2str(min_z(j)+4*ScanZ/10,'%0.2f'),' ', channel_info(j).Unit],...                                                                    % Sets the 5th tick with approriate labels
                                                    [num2str(min_z(j)+5*ScanZ/10,'%0.2f'),' ', channel_info(j).Unit],...                                                                    % Sets the 6th tick with approriate labels
                                                    [num2str(min_z(j)+6*ScanZ/10,'%0.2f'),' ', channel_info(j).Unit],...                                                                    % Sets the 7th tick with approriate labels
                                                    [num2str(min_z(j)+7*ScanZ/10,'%0.2f'),' ', channel_info(j).Unit],... 
                                                    [num2str(min_z(j)+8*ScanZ/10,'%0.2f'),' ', channel_info(j).Unit],...  
                                                    [num2str(min_z(j)+9*ScanZ/10,'%0.2f'),' ', channel_info(j).Unit],...                                                                    % Sets the 8th tick with approriate labels
                                                    [num2str(min_z(j)+10*ScanZ/10,'%0.2f'),' ', channel_info(j).Unit]},...                                                                  % Sets the 9th tick with approriate labels
                                                    'FontSize', FontSize, 'FontName', FontName);                                                                                            % Sets the font and size for the color bar
            set(hcb,'YTickMode','manual','FontSize', FontSize, 'FontName', FontName);                                                                                                       % Apply the font to the colorbar


        %This plots the integral scale bar.  It works...  It's not all my code.
        DistFactor                                  = 0.05;                                                                                                                                 % Scalebar height
        Length                                      = ScaleBar;                                                                                                                             % User set scalebar length
        Pos                                         = [0.5*max(size(intermediate_image(:,:))),0.95*max(size(intermediate_image(:,:)))];                                                                         % positions scale bar
        Scale                                       = ScanSize/(size(images,2)*(1+crop_fraction));                                                                                                              % Image scale
        UnitsName                                   = ' nm';                                                                                                                                % Units for the scale bar
        NextPlot                                    = get(gca,'NextPlot');                                                                                                              
        hold on;

        XLim                                        = get(gca,'XLim');
        YLim                                        = get(gca,'YLim');
        Xdiff                                       = abs(diff(XLim));
        Ydiff                                       = abs(diff(YLim));

        LineX                                       = Pos(1) + 0.5.*Length./Scale.*[-1;+1];
        LineY                                       = Pos(2).*[+1;+1];
        DistXdir                                    = 0;
        DistYdir                                    = -1;


        %--- plot line ---
        plot(LineX,LineY,'w-','LineWidth',2);


        %--- plot text ---
        DistX                                       = DistXdir.*DistFactor.*Xdiff;
        DistY                                       = DistYdir.*DistFactor.*Ydiff;

        Htext                                       = text(Pos(1)+DistX,Pos(2)+DistY,sprintf('%5.1f %s',Length,UnitsName));
        set(Htext,'HorizontalAlignment','center','Color', 'w', 'FontSize', FontSize, 'FontName', FontName);
        set(gca,'XLim',XLim);
        set(gca,'YLim',YLim);
        set(gca,'NextPlot',NextPlot);
        set(gca, 'XTickMode', 'manual');
        
        %print( '-r300', '-loose',  '-djpeg' , [ImageDir,'Matlab/Figure Jpegs/',channel_info(j).Name,'(',num2str(j),')','_',num2str(file_number),'.jpg']);
        print('-loose',  '-djpeg' , [ImageDir,'Matlab/Figure Jpegs/',channel_info(j).Name,'/',channel_info(j).Name,'(',num2str(j),')','_',num2str(file_number),'_intermediate.jpg']);        % Saves the images.  I'm not sure if i dig the naming just yet.  I'll deal with it later
        hold off;
        %close gcf;                                                                                                                                                                          % Closes each image after it's been saved.  Comment this out ony if working with a small number of files
    
    %catch exception
    %  [mess_warn id_warn] = lastwarn;
    %end
    